// Copyright  2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


using OneSpan.Digipass.Sdk.Utils.Notification.Server.Exceptions;
using System;
using System.Threading;

namespace OneSpan.Digipass.Sdk.Utils.Notification.Server.Sample
{
    /**
     * Test class for the NotificationSDKServer.
     * It demonstrates how to send a notification to Android and iOS devices using the NotificationSDKServer.
     */
    class NotificationSDKServerSample
    {
        // TODO: Paste here the VASCO notification identifier of your device, 
        // retrieved from your client sample integration after the notification service registration.
        // Ex: 01000001010200CC57504129317248645261724C51574C4E56396B6D6361564A756C456263327667586D70755650417454745462467663666A6D756B424C6463564266665068564B75504C76534B74386B516A37306B2D7A715748494832762D6C6968574B31326235776A4B674E4A55694C506343789E3852734D2D64536165326F37507262335048562D48736C594F6A564A6C3264694E774E4A626B79784C6F6A62676D4B654845784E5F61245E7947543443584C7744734A48123C5F597056504C3850726A7042756E5165571348EF5691A2 
        private static readonly string ANDROID_VASCO_NOTIFICATION_IDENTIFIER = "<VASCO notification identifier>";

        // TODO: Paste here the path to the Firebase service account JSON configuration file to be used
        // during the communication with the server.
        // Ex: "/path/to/firebase-service-account.json"
        private static readonly string ANDROID_FIREBASE_SERVICE_ACCOUNT_JSON = "<path to JSON file>";

        // TODO: Set to true if you want the android notification to be heads-up.
        private static readonly bool ANDROID_HEADS_UP = true;

        // TODO: Paste here the VASCO notification identifier of your device, 
        // retrieved from your client sample integration after the notification service registration.
        // Ex: 01000001020100473366623931383936203431666632343663206163356562366437203735316534396635206636632131383835203736373364303646206562663435646530206233373137306230
        private static readonly string IOS_VASCO_NOTIFICATION_IDENTIFIER = "<VASCO Notification identifier>";

        // TODO: Set to true if you want to use the sandbox gateway, set to false if not.
        private static readonly bool IOS_USE_SANDBOX_GATEWAY = true;

        // TODO: Paste here the path of your P8 file.
        // Ex: ./resources/apns.p8
        private static readonly string IOS_P8_FILE_PATH = "<IOS P8 File Path>";

        // TODO: Paste here the key ID.
        // Ex: 8Z9JNM2MG8
        private static readonly string IOS_KEY_ID = "<IOS Key ID>";

        // TODO: Paste here the team ID.
        // Ex: PS856PAVJ3
        private static readonly string IOS_TEAM_ID = "<IOS Team ID>";

        // TODO: Paste here the targeted bundle ID.
        // Ex: com.mycompany.myapp
        private static readonly string IOS_BUNDLE_ID = "<IOS Bundle ID>";

        static void Main(string[] args)
        {
            try
            {
                Console.WriteLine("*********************************************************************************");
                Console.WriteLine("*               Notification SDK Server - Sample demonstration                  *");
                Console.WriteLine("*********************************************************************************");
                Console.WriteLine();

                // Sets the server credentials
                NotificationSDKServerCredentials credentials = new NotificationSDKServerCredentials();
                //TODO: Uncomment the correct line to enable sending a certain type of notification
                //credentials.SetAndroidFirebaseServiceAccountJson(ANDROID_FIREBASE_SERVICE_ACCOUNT_JSON);
                //credentials.SetIOSPlatformCredentials(IOS_USE_SANDBOX_GATEWAY, IOS_P8_FILE_PATH, IOS_KEY_ID, IOS_TEAM_ID, IOS_BUNDLE_ID);

                // Sets the server settings
                NotificationSDKServerSettings settings = new NotificationSDKServerSettings();
                settings.ThreadMaxNumber = 20;
                settings.ConnectionTimeout = 20000;
                settings.ThreadTimeout = 60000;

                Console.WriteLine("Configuration:");
                Console.WriteLine("\tAndroid: " + ((credentials.AndroidFirebaseServiceAccountJson == null) ? "Not configured" : "OK"));
                Console.WriteLine("\tIOS: " + ((credentials.IOSP8CertificatePath == null) ? "Not configured" : "OK"));

                // Creates the NotificationSDKServer object
                NotificationSDKServer notificationServer = new NotificationSDKServer(credentials, settings);

                // Set callbacks
                notificationServer.OnSendNotificationError += (notificationTrackingIdentifier, vascoNotificationIdentifier, e) =>
                {
                    Console.WriteLine("[" + notificationTrackingIdentifier + "] vascoNotificationIdentifier: " + vascoNotificationIdentifier);
                    if (vascoNotificationIdentifier != null)
                    {
                        Console.WriteLine("[" + notificationTrackingIdentifier + "] platform name: " + notificationServer.GetPlatformName(vascoNotificationIdentifier));
                    }
                    Console.WriteLine("[" + notificationTrackingIdentifier + "] NotificationSDKServerException ErrorCode: " + e.ErrorCode + " - " + e.Message);
                    Console.WriteLine("[" + notificationTrackingIdentifier + "] " + e.GetBaseException().Message);
                };
                notificationServer.OnSendNotificationSuccess += (notificationTrackingIdentifier, vascoNotificationIdentifier) =>
                {
                    Console.WriteLine("[" + notificationTrackingIdentifier + "] vascoNotificationIdentifier: " + vascoNotificationIdentifier);
                    if (vascoNotificationIdentifier != null)
                    {
                        Console.WriteLine("[" + notificationTrackingIdentifier + "] platform name: " + notificationServer.GetPlatformName(vascoNotificationIdentifier));
                    }
                    Console.WriteLine("[" + notificationTrackingIdentifier + "] Notification success.");
                };

                // Sets the notification settings
                string notificationContent = "CONTENT of the notification";
                string notificationTitle = "TITLE of the notification";
                string notificationSubject = "SUBJECT of the notification";
                Notification notification = new Notification(notificationTitle, notificationSubject, notificationContent);

                // Android only, sets notificatio heads-up
                // notification.AndroidHeadsUp = ANDROID_HEADS_UP;

                // IOS only, sets the badge
                //notification.IOSBadge = 5;

                // Sends the notification to the Android device
                if (credentials.AndroidFirebaseServiceAccountJson != null) notificationServer.SendNotification(ANDROID_VASCO_NOTIFICATION_IDENTIFIER, notification);

                // Sends the notification to the iOS device
                if (credentials.IOSP8CertificatePath != null) notificationServer.SendNotification(IOS_VASCO_NOTIFICATION_IDENTIFIER, notification);

                // Stops and wait for the queues to drain
                notificationServer.AwaitSendTerminationAndFinish();
            }
            catch (NotificationSDKServerException e)
            {
                Console.WriteLine("NotificationSDKServerException ErrorCode: " + e.ErrorCode + " - " + e.Message);
            }

            // Keep the console window open in debug mode.
            Console.WriteLine("Press any key to exit.");
            Console.ReadKey();
        }
    }
}
